% Code for estimating the skewness model using Simulated Method of Moments (SMM)

clear; clc; tic

% Declare initial values for the parameters to be estimated
sigma_ea0=0.005; rhoa0=0.97; sigma_eps0=0.03; rho_eps0=0.99; sigma_es0=0.04; rhos0=0.95; omega0=4; rhoP0=0.5; rhoI0=0.5; %Used in successful estimation 110 

initparams=[ sigma_ea0 rhoa0 sigma_eps0 rho_eps0 sigma_es0 rhos0 omega0 rhoP0 rhoI0 ]; 

% Declare upper and lower bounds for these parameters, if any
lbound = [ 0    0    0   0     0    0.85  0  0   0  ]; 
ubound = [ 0.1  0.99 0.1 0.99 0.08  0.99 15 0.4  0.95]; 


% Initiate minimization of moment distances
[xparam,fval,exitflag,output] = fmincon(@SMM_skew,initparams,[],[],[],[],lbound,ubound);
% x contains the parameter estimates

% Collect moments and report them

load finaldatamoments_final; load finalmoments_revision;

Mmoments=[ finalmoments finaldatamoments ];
Comparemoments = [ sqrt(Mmoments(1,1)) sqrt(Mmoments(1,2)); sqrt(Mmoments(2,1)) sqrt(Mmoments(2,2)); sqrt(Mmoments(3,1)) sqrt(Mmoments(3,2));
                    sqrt(Mmoments(4,1)) sqrt(Mmoments(4,2)); sqrt(Mmoments(5,1)) sqrt(Mmoments(5,2)); 
                        Mmoments(6:end,:)];

save('estimates','xparam');
                    
close all
toc